SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT;
SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS;
SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION;
SET NAMES utf8;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE=NO_AUTO_VALUE_ON_ZERO */;


CREATE DATABASE /*!32312 IF NOT EXISTS*/ `rummage`;
USE `rummage`;
CREATE TABLE `family` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(45) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `family` (`id`,`name`,`description`) VALUES 
 (1,'Biking',''),
 (2,'World of Warcraft',''),
 (3,'Computer Hardware','');
CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url` varchar(45) NOT NULL default '',
  `name` varchar(45) NOT NULL default '',
  `software_id` int(10) unsigned NOT NULL default '0',
  `family_id` int(10) unsigned NOT NULL default '0',
  `search_flag` tinyint(3) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `software_id_index` TYPE BTREE (`software_id`),
  KEY `family_id_index` TYPE BTREE (`family_id`),
  CONSTRAINT `FK_family` FOREIGN KEY (`family_id`) REFERENCES `family` (`id`),
  CONSTRAINT `FK_software` FOREIGN KEY (`software_id`) REFERENCES `software` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `forum` (`id`,`url`,`name`,`software_id`,`family_id`,`search_flag`,`description`) VALUES 
 (1,'forums.mtbr.com','Mtbr Forum',1,1,0,'Ethan\'s favorite forum'),
 (2,'forums.roadbikereview.com','Road Bike Review',1,1,0,'Ethan likes the fixed gear forum'),
 (3,'wowforum.gamona.de','WorldofWar.de Foren',1,2,0,'Hier können Themen ausserhalb von World of Warcraft diskutiert werden.\r\n'),
 (4,'www.hardforum.com','[H]ard|Forum',1,3,0,'Nuttheads. Note: Forum only allows one search per minute.\r\n'),
 (7,'www.blizzardaddict.com','Blizzard Addict',1,2,0,'People with too much time.');
CREATE TABLE `result` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(45) NOT NULL default '',
  `link` text NOT NULL,
  `search_id` int(10) unsigned NOT NULL default '0',
  `forum_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `search_id_index` (`search_id`),
  KEY `forum_id_index` (`forum_id`),
  CONSTRAINT `FK_result_1` FOREIGN KEY (`search_id`) REFERENCES `search` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_result_2` FOREIGN KEY (`forum_id`) REFERENCES `forum` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='InnoDB free: 11264 kB; InnoDB free: 11264 kB; (`forum_id`) R';
INSERT INTO `result` (`id`,`title`,`link`,`search_id`,`forum_id`) VALUES 
 (113,'Passion-destroying bike traps.','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=93655&amp;highlight=ipod',12,1),
 (114,'Tunes for the Prez','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=94424&amp;highlight=ipod',12,1),
 (115,'My VT problem','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=92075&amp;highlight=ipod',12,1),
 (116,'Good solution for SUV gas guzzling problem?','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=76443&amp;highlight=ipod',12,1),
 (117,'Anyone night riding in phx tomorrow (Wed)?','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=92841&amp;highlight=ipod',12,1),
 (118,'5spot problem/warranty advice needed','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=93025&amp;highlight=ipod',12,1),
 (119,'Music???','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=93006&amp;highlight=ipod',12,1),
 (120,'Found this in the trash the other night','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=92697&amp;highlight=ipod',12,1),
 (121,'OT: Mp3 player that\'s loud &amp; clear, for t','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=76189&amp;highlight=ipod',12,1);
INSERT INTO `result` (`id`,`title`,`link`,`search_id`,`forum_id`) VALUES 
 (122,'Guess what Bush rides...','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=92630&amp;highlight=ipod',12,1),
 (123,'LET\'S RIDE - Maui','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=85772&amp;highlight=ipod',12,1),
 (124,'POLL:  Mac or PC?  Why?','showthread.php?s=a9dc809ca3059750102724487ab37fdc&amp;t=90286&amp;highlight=ipod',12,1),
 (125,'the PIE never ends','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=29229&amp;highlight=ipod',12,2),
 (126,'Tour De Ga: Pros with no helmets....','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=29077&amp;highlight=ipod',12,2),
 (127,'Market value of 1998 Trek 5020','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28990&amp;highlight=ipod',12,2),
 (128,'Who rides with Music? Or likes Pie?','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28933&amp;highlight=ipod',12,2),
 (129,'More proof CEOs don\'t live in the same world','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28803&amp;highlight=ipod',12,2),
 (130,'Introducing myself','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28752&amp;highlight=ipod',12,2);
INSERT INTO `result` (`id`,`title`,`link`,`search_id`,`forum_id`) VALUES 
 (131,'Tuesday Rant','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28744&amp;highlight=ipod',12,2),
 (132,'Riding with an iPod...','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28684&amp;highlight=ipod',12,2),
 (133,'im a idiot','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28356&amp;highlight=ipod',12,2),
 (134,'oil town, ridding suv\'s one bicycle at a time','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=27834&amp;highlight=ipod',12,2),
 (135,'First race report (longish)','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=28205&amp;highlight=ipod',12,2),
 (136,'Dummy brake lever - how, duh?','showthread.php?s=7afec7f757008fa1009e0f8c6cc78ec6&amp;t=27836&amp;highlight=ipod',12,2),
 (137,'2005 Post Your Workstation','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=847412&amp;highlight=ipod',12,4),
 (138,'Pepsi Itunes Thread','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=865571&amp;highlight=ipod',12,4),
 (139,'The &quot;I-Have-Too-Much-Stuff&quot; FS Thre','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=878755&amp;highlight=ipod',12,4);
INSERT INTO `result` (`id`,`title`,`link`,`search_id`,`forum_id`) VALUES 
 (140,'Show Your LCD(s) setups!!!','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=862341&amp;highlight=ipod',12,4),
 (141,'FS: 20 GB 4G iPod w/ case and 2 year warranty','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=893907&amp;highlight=ipod',12,4),
 (142,'Post your pc screen shots!','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=753262&amp;highlight=ipod',12,4),
 (143,'FS: iPod 10 Gig 2nd Gen + All Accessories','showthread.php?s=0ff1f4fa6f0de2dd77ca54f1e2749106&amp;t=892379&amp;highlight=ipod',12,4);
CREATE TABLE `search` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `query` varchar(45) NOT NULL default '',
  `name` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `search` (`id`,`query`,`name`) VALUES 
 (12,'ipod','ipod @ 2005-04-21T03:11:33-0800');
CREATE TABLE `software` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(45) NOT NULL default '',
  `query` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `software` (`id`,`name`,`query`) VALUES 
 (1,'vBulletin','/search.php?do=process&query=');
CREATE TABLE `topic` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(45) NOT NULL default '',
  `forum_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `forum_id_index` TYPE BTREE (`forum_id`),
  CONSTRAINT `FK_topic_1` FOREIGN KEY (`forum_id`) REFERENCES `forum` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT;
SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS;
SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
